<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2StoredInfoTypeStats extends \Google\Model
{
  protected $largeCustomDictionaryType = GooglePrivacyDlpV2LargeCustomDictionaryStats::class;
  protected $largeCustomDictionaryDataType = '';
  public $largeCustomDictionary;

  /**
   * @param GooglePrivacyDlpV2LargeCustomDictionaryStats
   */
  public function setLargeCustomDictionary(GooglePrivacyDlpV2LargeCustomDictionaryStats $largeCustomDictionary)
  {
    $this->largeCustomDictionary = $largeCustomDictionary;
  }
  /**
   * @return GooglePrivacyDlpV2LargeCustomDictionaryStats
   */
  public function getLargeCustomDictionary()
  {
    return $this->largeCustomDictionary;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2StoredInfoTypeStats::class, 'Google_Service_DLP_GooglePrivacyDlpV2StoredInfoTypeStats');
